//
//  CRImageFilterCurves.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 7/21/11.
//  Copyright 2011 Neatberry. All rights reserved.
//

#import "CRCIImageFilter.h"

@class CRCurve;
@class CRCIHistogram;

extern NSString* const CRImageFilterCurvesRedCurveKey;
extern NSString* const CRImageFilterCurvesGreenCurveKey;
extern NSString* const CRImageFilterCurvesBlueCurveKey;
extern NSString* const CRImageFilterCurvesGrayCurveKey;

//////////////////////////////////////////////////////////////////////
// Curves filter
//////////////////////////////////////////////////////////////////////
@interface CRImageFilterCurves : CRCIImageFilter
{
	BOOL				curvesDirty;
	NSBitmapImageRep*	curvesTable;
	
	CRCIHistogram*		histogram;
	
	CRCurve*			redCurve;
	CRCurve*			greenCurve;
	CRCurve*			blueCurve;
	CRCurve*			grayCurve;
}

@property (nonatomic, strong)	CRCurve*		redCurve;
@property (nonatomic, strong)	CRCurve*		greenCurve;
@property (nonatomic, strong)	CRCurve*		blueCurve;
@property (nonatomic, strong)	CRCurve*		grayCurve;

@property (nonatomic, readonly) CRCIHistogram*	histogram;

@end